package gov.va.vamf.scheduling.direct.domain;

import com.agilex.healthcare.veteranappointment.domain.Namespace;
import org.springframework.data.mongodb.core.mapping.Document;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.Optional;

@Document
@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(namespace = Namespace.DirectScheduling)
public class DirectBookingEligibilityCriteria extends DomainBaseObject {

    @XmlElement
    private CoreSettings coreSettings;

    public CoreSettings getCoreSettings() {
        return coreSettings;
    }

    public void setCoreSettings(CoreSettings coreSettings) {
        this.coreSettings = coreSettings;
    }

    /**
     * Searches coreSettings by id
     * @param settingId
     * @return the setting matching the given id
     */
    @SuppressWarnings("unchecked")
    public Optional<CoreSetting> getSetting(final String settingId) {
        if (coreSettings != null) {
            return coreSettings.findCoreSettingById(settingId);
        }

        return Optional.empty();
    }
}
